%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% sapthesis.cls                                                   %%
%% version 2.8                                                     %%
%% 2011-09-13                                                      %%
%% author: Francesco Biccari                                       %%
%% contact: biccari@gmail.com                                      %%
%%                                                                 %%
%% This file is the LaTeX class for the thesis style               %%
%% of the "Sapienza" -- University of Rome                         %%
%%                                                                 %%
%% see README for license information and installation             %%
%% see sapthesis-doc.pdf for usage                                 %%
%% see sapthesis-example.pdf for document examples                 %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Identification %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{sapthesis}%
[2011/09/13 Sapienza - University of Rome thesis class]



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Options %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\RequirePackage{xkeyval}
\newlength{\SAP@binding}
\newif\ifSAP@nodefaultfont \SAP@nodefaultfontfalse
\newif\ifSAP@romandiff \SAP@romandifffalse
\newif\ifSAP@customlanguage \SAP@customlanguagefalse
\newif\ifSAP@bn \SAP@bnfalse
\newif\ifSAP@PhD \SAP@PhDfalse
\newif\ifSAP@PhDA \SAP@PhDAfalse
\newif\ifSAP@PhDB \SAP@PhDBfalse
\newif\ifSAP@MasterP \SAP@MasterPfalse
\newif\ifSAP@MasterS \SAP@MasterSfalse
\newif\ifSAP@LaM \SAP@LaMfalse
\newif\ifSAP@Lau \SAP@Laufalse
\newif\ifSAP@noexaminfo \SAP@noexaminfofalse
\newcommand{\SAP@customlanguage}{}

\define@key[sap]{}{noexaminfo}[]{\SAP@noexaminfotrue}
\define@key[sap]{}{nodefaultfont}[]{\SAP@nodefaultfonttrue}
\define@key[sap]{}{romandiff}[]{\SAP@romandifftrue}
\define@key[sap]{}{italian}[]{\SAP@customlanguagetrue\renewcommand{\SAP@customlanguage}{\SAP@italian}}
\define@key[sap]{}{english}[]{\SAP@customlanguagetrue\renewcommand{\SAP@customlanguage}{\SAP@english}}
\define@key[sap]{}{bn}[]{\SAP@bntrue\PassOptionsToPackage{monochrome}{color}\PassOptionsToPackage{monochrome}{xcolor}}
\define@key[sap]{}{PhD}[]{\SAP@PhDtrue}
\define@key[sap]{}{LaM}[]{\SAP@LaMtrue}
\define@key[sap]{}{Lau}[]{\SAP@Lautrue}
\define@key[sap]{}{PhDA}[]{\SAP@PhDAtrue\SAP@PhDtrue}
\define@key[sap]{}{PhDB}[]{\SAP@PhDBtrue\SAP@PhDtrue}
\define@key[sap]{}{MasterP}[]{\SAP@MasterPtrue\SAP@MasterPtrue}
\define@key[sap]{}{MasterS}[]{\SAP@MasterStrue\SAP@MasterStrue}
\define@key[sap]{}{binding}[0pt]{\setlength{\SAP@binding}{#1}}
\define@key[sap]{}{draft}[]{\PassOptionsToClass{draft}{book}}
\define@key[sap]{}{oneside}[]{\PassOptionsToClass{oneside}{book}}
\define@key[sap]{}{twoside}[]{}
\DeclareOptionX*{\ClassError{sapthesis}{Option '\CurrentOption'%
  \MessageBreak is not valid}{Remove '\CurrentOption' %
  from class options}}
\ProcessOptionsX[sap]<>
\LoadClass[a4paper,11pt]{book}


\ifSAP@PhD\relax\else
  \ifSAP@LaM\relax\else
    \ifSAP@Lau\relax\else
      \ifSAP@MasterP\relax\else
        \ifSAP@MasterS\relax\else
          \ClassError{sapthesis}{You must specify the PhD, LaM, Lau, %
          MasterP or MasterS option}{You can use also special options PhDA, PhDB, ...}
        \fi
      \fi
    \fi
  \fi
\fi



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Page layout %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\RequirePackage{geometry}
\geometry{textwidth=396pt,
  textheight=650pt,
  marginparsep=12pt,
  bindingoffset=\SAP@binding,
  hmarginratio=61:99,
  vmarginratio=72:99,
  heightrounded,
  marginparwidth=72pt}
  
\if@twoside
  \geometry{hmarginratio=61:99}
\else
  \geometry{hmarginratio=1:1}
\fi



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Packages %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\RequirePackage{ifxetex}
\ifxetex
  \RequirePackage{xltxtra}
\else
  \ifSAP@nodefaultfont\relax\else
    \RequirePackage[T1]{fontenc}
    \RequirePackage{textcomp}
    \RequirePackage{lmodern}
  \fi
\fi
\RequirePackage{caption}
\captionsetup{indention=\parindent,labelfont={small,bf},labelsep=period,%
  tableposition=top,textfont={small}}
\RequirePackage{graphicx}
\RequirePackage{color}
\RequirePackage{booktabs}
\RequirePackage{amsmath}
\RequirePackage{fancyhdr}
\RequirePackage{emptypage}

\newcommand{\SAP@twosidestyle}{%
\pagestyle{fancy}
\renewcommand{\chaptermark}[1]{\markboth{\thechapter.\ ##1}{}}
\renewcommand{\sectionmark}[1]{\markright{\thesection\ ##1}}
\fancyhf{}
\fancyhead[LE,RO]{\small\bfseries\thepage}
\fancyhead[LO]{\small\bfseries\nouppercase{\rightmark}}
\fancyhead[RE]{\small\bfseries\nouppercase{\leftmark}}
\renewcommand{\headrulewidth}{0.4pt}
\renewcommand{\footrulewidth}{0pt}
\addtolength{\headheight}{0.4pt} % Riserva spazio per la linea
}

\newcommand{\SAP@onesidestyle}{%
\pagestyle{fancy}
\renewcommand{\chaptermark}[1]{\markboth{\thechapter.\ ##1}{}}
\fancyhf{}
\fancyhead[R]{\small\bfseries\thepage}
\fancyhead[L]{\small\bfseries\nouppercase{\leftmark}}
\renewcommand{\headrulewidth}{0.4pt}
\renewcommand{\footrulewidth}{0pt}
\addtolength{\headheight}{0.4pt} % Riserva spazio per la linea
}

\fancypagestyle{plain}{%
\renewcommand{\headrulewidth}{0pt}%
\fancyhf{}\fancyfoot[C]{\small\bfseries\thepage}}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% numbering objects per chapters (e.g. 1.1, 1.2, ...) %%%%%%%%%%%%%%

\numberwithin{equation}{chapter}
\numberwithin{figure}{chapter}
\numberwithin{table}{chapter}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Fancy headers %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\g@addto@macro\frontmatter{\pagestyle{plain}}
\g@addto@macro\mainmatter{%
  \if@twoside\SAP@twosidestyle\else\SAP@onesidestyle\fi%
}

% fancy marginnote
% footnotesize marginpar
\g@addto@macro\@marginparreset{\footnotesize\itshape}
% new command for fancy margin note
\newcommand{\mnote}[1]{\marginpar[\raggedleft #1]{\raggedright #1}}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% redefinition of the \maketitle command to generate the titlepage %

%% GENERAL COMMANDS

\newcommand\@courseorganizerLabel{}
\newcommand\@courseLabel{}
\newcommand\@PhDcourseDeclarationLabel{}
\ifSAP@PhDA
  \renewcommand\@courseorganizerLabel{Scuola di Dottorato in Scienze Astronomiche,\\
    Chimiche, Fisiche e Matematiche ``Vito Volterra''}
  \renewcommand\@courseLabel{Fisica}
  \renewcommand\@PhDcourseDeclarationLabel{Physics}
\fi
\ifSAP@PhDB
  \renewcommand\@courseorganizerLabel{Scuola di Dottorato in Scienze Astronomiche,\\
    Chimiche, Fisiche e Matematiche ``Vito Volterra''}
  \renewcommand\@courseLabel{Matematica}
  \renewcommand\@PhDcourseDeclarationLabel{Mathematics}
\fi
\newcommand{\courseorganizer}[1]{\renewcommand\@courseorganizerLabel{#1}}
\newcommand{\course}[2][]{%
  \renewcommand\@courseLabel{#2}
  \renewcommand\@PhDcourseDeclarationLabel{\if?#1?\@courseLabel\else#1\fi}}

\newcommand\@copyyear{}
\newcommand{\copyyear}[1]{\renewcommand\@copyyear{#1}}

\newcommand\@cycle{}
\newcommand{\cycle}[1]{\renewcommand\@cycle{#1}}

\newcommand\@submitdate{}
\newcommand{\submitdate}[1]{\renewcommand\@submitdate{#1}}

\newcommand\@IDnumber{}
\newcommand{\IDnumber}[1]{\renewcommand\@IDnumber{#1}}

\newcount\SAP@advisorcount
\newtoks\SAP@advisortoks
\newcommand{\advisor}[1]{% 
  \ifnum\SAP@advisorcount=\z@ 
    \SAP@advisortoks={#1}% 
  \else 
    \SAP@advisortoks=\expandafter{\the\SAP@advisortoks\\[0.75mm]#1}% 
  \fi 
  \advance\SAP@advisorcount\@ne}

\newcount\SAP@coadvisorcount
\newtoks\SAP@coadvisortoks
\newcommand{\coadvisor}[1]{% 
  \ifnum\SAP@coadvisorcount=\z@ 
    \SAP@coadvisortoks={#1}% 
  \else 
    \SAP@coadvisortoks=\expandafter{\the\SAP@coadvisortoks\\[0.75mm]#1}% 
  \fi 
  \advance\SAP@coadvisorcount\@ne}
  
\newcount\SAP@examinercount
\newtoks\SAP@examinertoks
\newcommand{\examiner}[1]{% 
  \ifnum\SAP@examinercount=\z@ 
    \SAP@examinertoks={#1 (\@chairman)}% 
  \else 
    \SAP@examinertoks=\expandafter{\the\SAP@examinertoks\\[0.75mm]#1}% 
  \fi 
  \advance\SAP@examinercount\@ne}

\newcommand\@examdate{}
\newcommand{\examdate}[1]{\renewcommand\@examdate{#1}}

\newcommand\@versiondate{}
\newcommand{\versiondate}[1]{\renewcommand\@versiondate{#1}}

\newcommand\@authoremail{}
\newcommand{\authoremail}[1]{\renewcommand\@authoremail{#1}}

\newcommand\@website{}
\newcommand{\website}[1]{\renewcommand\@website{#1}}

\newcommand\@ISBN{}
\newcommand{\ISBN}[1]{\renewcommand\@ISBN{#1}}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% PhD maketitle

\newcommand{\maketitlePhD}{

% Errors:

\if|\@courseorganizerLabel|\ClassError{sapthesis}{You must specify the Ph.D. %
  organizer}{Example: \protect\courseorganizer{Scuola di dottorato di ...}}\fi
\if|\@courseLabel|\ClassError{sapthesis}{You must specify the Ph.D. %
  course}{Example: \protect\course{Fisica}{Physics}}\fi
\if|\@cycle|\ClassError{sapthesis}{You must specify the Ph.D. %
  cycle (cycle)}{The Ph.D. cycle must be in the roman numbers}\fi
\if|\@submitdate|\ClassError{sapthesis}{You must specify the %
  thesis submission date}{The date must be in the form Month(name) Year(number)}\fi
\if|\@copyyear|\ClassError{sapthesis}{You must specify the %
  copyright year}{Example: \protect\copyyear{2012}}\fi
\if|\@IDnumber|\ClassError{sapthesis}{You must specify your %
  ID number (matricola)}{E.g. 123456}\fi
\if|\@authoremail|\ClassError{sapthesis}{You must specify the email of the author}{%
  Example: \protect\authoremail{author@email.com}}\fi

% Titlepage:

	\begin{titlepage}

    \newcommand{\SAP@parbox}[2][]{\hspace{1.72cm}\parbox[t][##1][t]{11.9cm}{##2}}
    \parindent=0pt
    \sffamily

    \vspace*{-10mm}
    \ifSAP@bn
      \includegraphics[width=5cm]{marchiologo_nero_positivo}
    \else
      \includegraphics[width=5cm]{marchiologo_rosso_positivo}
    \fi

    \nointerlineskip
    \vspace{\stretch{1}}
    \nointerlineskip

    \SAP@parbox{\LARGE\textcolor{sapred}{\@title}\par}

    \vspace{\stretch{1}}

    \SAP@parbox[3cm]{%
    \textcolor{sapred}{\@courseorganizerLabel\\[2mm]
    Dottorato di Ricerca in \@courseLabel\ -- \@cycle\ Ciclo}}

    \SAP@parbox[3cm]{%
    \@CandidateLabel\\[2mm]
    \@author\\[0.75mm]
    \@IDnumberLabel\ \@IDnumber}

    
    
    
    \SAP@parbox[4.5cm]{%
    \makebox[11.9cm][l]{%
      \parbox[t]{5.9cm}{%
        \ifcase\SAP@advisorcount
          \ClassError{sapthesis}{You must specify at least one advisor in the preamble}%
          {E.g. \protect\advisor{Prof. Name Surname}}
        \or
          \@ThesisAdvisorLabel\\[2mm]
        \else
          \@ThesisAdvisorsLabel\\[2mm]
        \fi
        \the\SAP@advisortoks}
        \hspace{1.5cm}
        \parbox[t]{5.9cm}{%
        \ifcase\SAP@coadvisorcount
          \relax
        \or
          \@ThesisCoAdvisorLabel\\[2mm]
        \else
          \@ThesisCoAdvisorsLabel\\[2mm]
        \fi
        \the\SAP@coadvisortoks}
    }}

    \SAP@parbox{\@DeclarationLabel\ \@PhDcourseDeclarationLabel\\[2mm]
    \@submitdate}
    
	\end{titlepage}
\clearpage
\thispagestyle{empty}

\ifSAP@noexaminfo
\null
\vfill
\else
\vspace*{\stretch{0.1}}

\noindent
\if?\@examdate?
  \@ThesisNotDefensedLabel%
\else
  \@ThesisDefensedLabelA\ \@examdate\\
  \@ThesisDefensedLabelB:\\[2mm]
  \the\SAP@examinertoks%
\fi

\vspace{\stretch{0.8}}

\fi

\noindent
\@author. \textit{\def\\{}\def\newline{} \@title.} \\[0.75mm]
\@PhDthesistype. \@sapienzaname \\[0.75mm]
\copyright\ \@copyyear\quad%
\if|\@ISBN|
  \relax%
\else
  ISBN: \@ISBN %
\fi

\begin{flushright}
\if|\@versiondate|
  \relax%
\else
  \textsc{\@versionLabel:} \@versiondate \\[2mm]%
\fi
\if|\@website|
  \relax%
\else
  \textsc{\@websiteLabel:} \@ifundefined{href}{\@website}{\href{\@website}{\@website}} \\[2mm]%
\fi
\textsc{email:} \@ifundefined{href}{\@authoremail}{\href{mailto:\@authoremail}{\@authoremail}}\par
\end{flushright}

\cleardoublepage
}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Laurea and Laurea Magistrale maketitle

\newcommand{\maketitleLaurea}{

% Errors:

\if|\@courseorganizerLabel|\ClassError{sapthesis}{You must specify the degree %
  organizer}{Example: \protect\courseorganizer{Faculty of ...}}\fi
\if|\@submitdate|\ClassError{sapthesis}{You must specify the Academic %
  Year}{Example: \protect\submitdate{2011/2012}}\fi
\if|\@IDnumber|\ClassError{sapthesis}{You must specify your %
  ID number (matricola)}{E.g. 123456}\fi
\if|\@copyyear|\ClassError{sapthesis}{You must specify the %
  copyright year}{Example: \protect\copyyear{2012}}\fi
\if|\@authoremail|\ClassError{sapthesis}{You must specify the email of the author}{%
  Example: \protect\authoremail{author@email.com}}\fi

% Titlepage:

	\begin{titlepage}

    \newcommand{\SAP@parbox}[2][]{\hspace{1.72cm}\parbox[t][##1][t]{11.9cm}{##2}}
    \parindent=0pt
    \sffamily

    \vspace*{-10mm}
    \ifSAP@bn
      \includegraphics[width=5cm]{marchiologo_nero_positivo}
    \else
      \includegraphics[width=5cm]{marchiologo_rosso_positivo}
    \fi

    \nointerlineskip
    \vspace{\stretch{0.9}}
    \nointerlineskip

    \SAP@parbox{\LARGE\textcolor{sapred}{\@title}\par}

    \vspace{\stretch{0.9}}

    \SAP@parbox[3cm]{%
    \textcolor{sapred}{\@courseorganizerLabel\\[2mm]
    Corso di Laurea \ifSAP@LaM Magistrale \fi in \@courseLabel}}

    \SAP@parbox[3cm]{%
    \@CandidateLabel\\[2mm]
    \@author\\[0.75mm]
    \@IDnumberLabel\ \@IDnumber}

    \SAP@parbox[4.5cm]{%
    \makebox[11.9cm][l]{%
      \parbox[t]{5.9cm}{%
        \ifcase\SAP@advisorcount
          \ClassError{sapthesis}{You must specify at least one advisor in the preamble}%
          {E.g. \protect\advisor{Prof. Name Surname}}
        \or
          \@ThesisAdvisorLabel\\[2mm]
        \else
          \@ThesisAdvisorsLabel\\[2mm]
        \fi
        \the\SAP@advisortoks}
        \hspace{1.5cm}
        \parbox[t]{5.9cm}{%
        \ifcase\SAP@coadvisorcount
          \relax
        \or
          \@ThesisCoAdvisorLabel\\[2mm]
        \else
          \@ThesisCoAdvisorsLabel\\[2mm]
        \fi
        \the\SAP@coadvisortoks}
    }}

    \SAP@parbox{\@AcademicYearLabel\ \@submitdate}
    
	\end{titlepage}
\clearpage
\thispagestyle{empty}

\ifSAP@noexaminfo
\null
\vfill
\else
\vspace*{\stretch{0.1}}

\noindent
\if?\@examdate?
  \@ThesisNotDefensedLabel%
\else
  \@ThesisDefensedLabelA\ \@examdate\\
  \@ThesisDefensedLabelB:\\[2mm]
  \the\SAP@examinertoks%
\fi

\vspace{\stretch{0.8}}
\fi

\noindent
\@author. \textit{\def\\{}\def\newline{} \@title.} \\[0.75mm]
\ifSAP@Lau\@Lauthesistype\else\@LaMthesistype\fi. \@sapienzaname \\[0.75mm]
\copyright\ \@copyyear\quad%
\if|\@ISBN|
  \relax%
\else
  ISBN: \@ISBN %
\fi

\begin{flushright}
\if|\@versiondate|
  \relax%
\else
  \textsc{\@versionLabel:} \@versiondate \\[2mm]%
\fi
\if|\@website|
  \relax%
\else
  \textsc{\@websiteLabel:} \@ifundefined{href}{\@website}{\href{\@website}{\@website}} \\[2mm]%
\fi
\textsc{email:} \@ifundefined{href}{\@authoremail}{\href{mailto:\@authoremail}{\@authoremail}}\par
\end{flushright}

\cleardoublepage
}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Master di primo livello and
%% Master di secondo livello maketitle

\newcommand{\maketitleMaster}{

% Errors:

\if|\@courseorganizerLabel|\ClassError{sapthesis}{You must specify the degree %
  organizer}{Example: \protect\courseorganizer{Faculty of ...}}\fi
\if|\@submitdate|\ClassError{sapthesis}{You must specify the Academic %
  Year}{Example: \protect\submitdate{2011/2012}}\fi
\if|\@IDnumber|\ClassError{sapthesis}{You must specify your %
  ID number (matricola)}{E.g. 123456}\fi
\if|\@copyyear|\ClassError{sapthesis}{You must specify the %
  copyright year}{Example: \protect\copyyear{2012}}\fi
\if|\@authoremail|\ClassError{sapthesis}{You must specify the email of the author}{%
  Example: \protect\authoremail{author@email.com}}\fi

% Titlepage:

	\begin{titlepage}

    \newcommand{\SAP@parbox}[2][]{\hspace{1.72cm}\parbox[t][##1][t]{11.9cm}{##2}}
    \parindent=0pt
    \sffamily

    \vspace*{-10mm}
    \ifSAP@bn
      \includegraphics[width=5cm]{marchiologo_nero_positivo}
    \else
      \includegraphics[width=5cm]{marchiologo_rosso_positivo}
    \fi

    \nointerlineskip
    \vspace{\stretch{0.9}}
    \nointerlineskip

    \SAP@parbox{\LARGE\textcolor{sapred}{\@title}\par}

    \vspace{\stretch{0.9}}

    \SAP@parbox[3cm]{%
    \textcolor{sapred}{\@courseorganizerLabel\\[2mm]
    Master di \ifSAP@MasterP primo \fi \ifSAP@MasterS secondo \fi livello in \@courseLabel}}

    \SAP@parbox[3cm]{%
    \@CandidateLabel\\[2mm]
    \@author\\[0.75mm]
    \@IDnumberLabel\ \@IDnumber}

    \SAP@parbox[4.5cm]{%
    \makebox[11.9cm][l]{%
      \parbox[t]{5.9cm}{%
        \ifcase\SAP@advisorcount
          \ClassError{sapthesis}{You must specify at least one advisor in the preamble}%
          {E.g. \protect\advisor{Prof. Name Surname}}
        \or
          \@ThesisAdvisorLabel\\[2mm]
        \else
          \@ThesisAdvisorsLabel\\[2mm]
        \fi
        \the\SAP@advisortoks}
        \hspace{1.5cm}
        \parbox[t]{5.9cm}{%
        \ifcase\SAP@coadvisorcount
          \relax
        \or
          \@ThesisCoAdvisorLabel\\[2mm]
        \else
          \@ThesisCoAdvisorsLabel\\[2mm]
        \fi
        \the\SAP@coadvisortoks}
    }}

    \SAP@parbox{\@AcademicYearLabel\ \@submitdate}
    
	\end{titlepage}
\clearpage
\thispagestyle{empty}

\ifSAP@noexaminfo
\null
\vfill
\else
\vspace*{\stretch{0.1}}

\noindent
\if?\@examdate?
  \@ThesisNotDefensedLabel%
\else
  \@ThesisDefensedLabelA\ \@examdate\\
  \@ThesisDefensedLabelB:\\[2mm]
  \the\SAP@examinertoks%
\fi

\vspace{\stretch{0.8}}
\fi

\noindent
\@author. \textit{\def\\{}\def\newline{} \@title.} \\[0.75mm]
\ifSAP@MasterP\@MasterPthesistype\else\@MasterSthesistype\fi. \@sapienzaname \\[0.75mm]
\copyright\ \@copyyear\quad%
\if|\@ISBN|
  \relax%
\else
  ISBN: \@ISBN %
\fi

\begin{flushright}
\if|\@versiondate|
  \relax%
\else
  \textsc{\@versionLabel:} \@versiondate \\[2mm]%
\fi
\if|\@website|
  \relax%
\else
  \textsc{\@websiteLabel:} \@ifundefined{href}{\@website}{\href{\@website}{\@website}} \\[2mm]%
\fi
\textsc{email:} \@ifundefined{href}{\@authoremail}{\href{mailto:\@authoremail}{\@authoremail}}\par
\end{flushright}

\cleardoublepage
}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Choosing the right \maketitle according to the
%% type of the thesis

\renewcommand{\maketitle}{%
  \ifSAP@PhD\maketitlePhD\fi
  \ifSAP@LaM\maketitleLaurea\fi
  \ifSAP@Lau\maketitleLaurea\fi
  \ifSAP@MasterS\maketitleMaster\fi
  \ifSAP@MasterP\maketitleMaster\fi}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% DEDICATION COMMAND %%
\providecommand*{\dedication}[1]{%
\cleardoublepage
\thispagestyle{empty}
\null\vspace{\stretch{0.26}}
\begin{flushright}
\textit{#1}
\end{flushright}
\vspace{\stretch{0.74}}\null}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% ABSTRACT ENVIRONMENT %%
\newenvironment{abstract}[1][\@AbstractLabel]%
{\cleardoublepage%
  \null\begin{center}{\large \bfseries #1}\end{center}%
}%
{\null}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% ACKNOWLEDGMENTS ENVIRONMENT %%
\newenvironment{acknowledgments}[1][\@AcknowledgmentsLabel]%
{\cleardoublepage
\null\begin{center}{\large \bfseries #1}\end{center}\itshape}%
{\null}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% LANGUAGE COMMANDS %%

\newcommand{\SAP@english}{%
  \newcommand{\@CandidateLabel}{Candidate}
  \newcommand{\@IDnumberLabel}{ID number}
  \newcommand{\@ThesisAdvisorLabel}{Thesis Advisor}
  \newcommand{\@ThesisAdvisorsLabel}{Thesis Advisors}
  \newcommand{\@ThesisCoAdvisorLabel}{Co-Advisor}
  \newcommand{\@ThesisCoAdvisorsLabel}{Co-Advisors}
  \newcommand{\@DeclarationLabel}{A thesis
  submitted in partial fulfillment of the requirements\\
    for the degree of Doctor of Philosophy in}
  \newcommand{\@ThesisNotDefensedLabel}{Thesis not yet defended}
  \newcommand{\@ThesisDefensedLabelA}{Thesis defended on}
  \newcommand{\@ThesisDefensedLabelB}{in front of a Board of Examiners composed by}
  \newcommand{\@chairman}{chairman}
  \newcommand{\@PhDthesistype}{Ph.D. thesis}
  \newcommand{\@LaMthesistype}{Master thesis}
  \newcommand{\@Lauthesistype}{Bachelor thesis}
  \newcommand{\@MasterPthesistype}{First level master thesis}
  \newcommand{\@MasterSthesistype}{Second level master thesis}
  \newcommand{\@sapienzaname}{Sapienza -- University of Rome}
  \newcommand{\@versionLabel}{version}
  \newcommand{\@websiteLabel}{website}
  \newcommand{\@AcknowledgmentsLabel}{Acknowledgments}
  \newcommand{\@AbstractLabel}{Abstract}
  \newcommand{\@AcademicYearLabel}{Academic Year}}

\newcommand{\SAP@italian}{%
  \newcommand{\@CandidateLabel}{Candidato}
  \newcommand{\@IDnumberLabel}{Matricola}
  \newcommand{\@ThesisAdvisorLabel}{Relatore}
  \newcommand{\@ThesisAdvisorsLabel}{Relatori}
  \newcommand{\@ThesisCoAdvisorLabel}{Correlatore}
  \newcommand{\@ThesisCoAdvisorsLabel}{Correlatori}
  \newcommand{\@DeclarationLabel}{Tesi presentata
  in parziale adempimento dei requisiti necessari\\
  per conseguire il titolo di Dottore di Ricerca in}
  \newcommand{\@ThesisNotDefensedLabel}{Tesi non ancora discussa}
  \newcommand{\@ThesisDefensedLabelA}{Tesi discussa il}
  \newcommand{\@ThesisDefensedLabelB}{di fronte a una commissione esaminatrice composta da}
  \newcommand{\@chairman}{presidente}
  \newcommand{\@PhDthesistype}{Tesi di dottorato}
  \newcommand{\@LaMthesistype}{Tesi di Laurea Magistrale}
  \newcommand{\@Lauthesistype}{Tesi di Laurea}
  \newcommand{\@MasterPthesistype}{Tesi di Master di primo livello}
  \newcommand{\@MasterSthesistype}{Tesi di Master di secondo livello}
  \newcommand{\@sapienzaname}{Sapienza -- Universit\`a di Roma}
  \newcommand{\@versionLabel}{versione}
  \newcommand{\@websiteLabel}{sito web}
  \newcommand{\@AcknowledgmentsLabel}{Ringraziamenti}
  \newcommand{\@AbstractLabel}{Sommario}
  \newcommand{\@AcademicYearLabel}{Anno Accademico}}

  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% USEFUL COMMANDS %%

\newcommand*{\SAP@upbox}[1]{\textrm{\upshape#1}} 
\AtBeginDocument{

  \definecolor{sapred}{rgb}{0.5098039,0.1411765,0.2}

  % scritte in funzione della lingua del documento. Default inglese.
  \ifSAP@customlanguage
    \SAP@customlanguage
  \else
    \@ifpackageloaded{babel}{\csname SAP@\languagename\endcsname}{%
      \@ifpackageloaded{polyglossia}{\csname SAP@\languagename\endcsname}{\SAP@english}}
  \fi

  % degree 
  \providecommand{\degree}{\SAP@upbox{\textdegree}} 
  \providecommand{\g}{\degree} 

  % gradi Celsius
  \providecommand{\celsius}{\ensuremath{\SAP@upbox{\textdegree}\kern-\scriptspace\mathrm{C}}}
  \ifxetex
    \ProvideTextCommandDefault{\C}{\celsius}
  \else
    \providecommand{\C}{\celsius}
  \fi
  
  % Angstrom 
  \providecommand{\angstrom}{\SAP@upbox{\AA}} 
  \providecommand{\A}{\angstrom} 
  
  % micro 
  \providecommand{\micro}{\SAP@upbox{\textmu}} 
  
  % Ohm 
  \providecommand{\ohm}{\SAP@upbox{\textohm}} 
  
  % times (only math) 
  \providecommand{\x}{\times} 
  
  % measurement unit 
  \providecommand*{\un}[1]{\ensuremath{\mathrm{\,#1}}} 

  % Napier's number 
  \providecommand{\eu}{\ensuremath{\mathrm{e}}} 
  
  % imaginary unit 
  \providecommand{\iu}{\ensuremath{\mathrm{i}}} 
  
  % roman subscript 
  \providecommand*{\rb}[1]{\ensuremath{_\mathrm{#1}}} 
  
  % roman superscript 
  \providecommand*{\rp}[1]{\ensuremath{^\mathrm{#1}}} 

  % differential (only math)
  \ifSAP@romandiff
    \providecommand{\di}{\mathop{}\!\mathrm{d}}
  \else
    \providecommand{\di}{\mathop{}\!d}
  \fi
  
  % derivative and partial derivative (only math) 
  \providecommand*{\der}[3][]{\frac{d\if?#1?\else^{#1}\fi#2}{d #3\if?#1?\else^{#1}\fi}} 
  \providecommand*{\pder}[3][]{% 
    \frac{\partial\if?#1?\else^{#1}\fi#2}{\partial #3\if?#1?\else^{#1}\fi}% 
  }

  % subscript and superscript in text mode
  \DeclareRobustCommand*\textsubscript[1]{\@textsubscript{\selectfont#1}} 
  \def\@textsubscript#1{{\m@th\ensuremath{_{\mbox{\fontsize\sf@size\z@#1}}}}}
  \providecommand*{\tb}[1]{\textsubscript{#1}}
  \providecommand*{\tp}[1]{\textsuperscript{#1}}
}