%%
%% This is file `suftesi.cls',
%%
%%  Copyright (C) 2010-11 Ivan Valbusa
%% 
%%  This program is provided under the terms of the
%%  LaTeX Project Public License distributed from CTAN
%%  archives in directory macros/latex/base/lppl.txt.
%% 
%%  Author: Ivan Valbusa
%%          ivan dot valbusa at univr dot it
%% 
%%  This work has the LPPL maintenance status "author-maintained".
%% 
\NeedsTeXFormat{LaTeX2e}[2005/12/01]
\ProvidesClass{suftesi}
		[2011/11/07 v. 0.6b
		A class for typesetting theses, books and articles]
%****************************************
%  declare options
%****************************************
\newif\ifsuftesi@centertitle
\newif\ifsuftesi@sctitles
\newif\ifsuftesi@artemisia 
\newif\ifsuftesi@porson 
\newif\ifsuftesi@defaultfont 
\newif\ifsuftesi@defaultgreek
\newif\ifsuftesi@centerheadings
\newif\ifsuftesi@sufplain
\newif\ifsuftesi@bozza
\newif\ifsuftesi@article
\newif\ifsuftesi@authortitle
\newif\ifsuftesi@nofront
\newif\ifsuftesi@compact
\newif\ifsuftesi@supercompact
\newif\ifsuftesi@elements
\newif\ifsuftesi@sufelements
\newif\ifsuftesi@nocrop
\newif\ifsuftesi@nomarginpar
\DeclareOption{centertitle}{\suftesi@centertitletrue}
\DeclareOption{sctitles}{\suftesi@sctitlestrue}
\DeclareOption{disablefront}{\suftesi@nofronttrue}
\DeclareOption{defaultfont}{\suftesi@defaultfonttrue\suftesi@defaultgreektrue}
\DeclareOption{artemisia}{\suftesi@artemisiatrue\suftesi@porsonfalse	\suftesi@defaultgreekfalse} 
\DeclareOption{porson}{\suftesi@porsontrue\suftesi@artemisiafalse
	\suftesi@defaultgreekfalse} 
\DeclareOption{defaultgreek}{\suftesi@defaultgreektrue
	\suftesi@artemisiafalse\suftesi@porsonfalse} 
\DeclareOption{centerheadings}{\suftesi@centerheadingstrue} 
\DeclareOption{sufplain}{\suftesi@sufplaintrue} 
\DeclareOption{bozza}{\suftesi@bozzatrue} 
\DeclareOption{compact}{\suftesi@compacttrue} 
\DeclareOption{supercompact}{\suftesi@supercompacttrue} 
\DeclareOption{elements}{\suftesi@elementstrue\suftesi@sufelementstrue} 
\DeclareOption{sufelements}{\suftesi@sufelementstrue\suftesi@sctitlestrue} 
\DeclareOption{nocrop}{\suftesi@nocroptrue} 
\DeclareOption{nomarginpar}{\suftesi@nomarginpartrue} 
\DeclareOption{article}{\suftesi@articletrue}
\DeclareOption{authortitle}{\suftesi@authortitletrue}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}
\ExecuteOptions{artemisia} 
\ProcessOptions
\relax
\ifsuftesi@article
\LoadClass[a4paper,notitlepage]{book}
\else
\LoadClass[a4paper]{book}
\fi
%****************************************
% 		PACKAGES
%****************************************
\RequirePackage{color}
	\definecolor{sufred}{rgb}{0.5,0,0}
	\definecolor{sufgray}{rgb}{0.5,0.5,0.5}
\RequirePackage{ifxetex,ifluatex,metalogo}
\ifxetex\relax
  \else
    \RequirePackage[letterspace=110]{microtype}
      \microtypesetup{expansion=false}%
    \fi
\RequirePackage{textcase}
\RequirePackage{multicol}
\RequirePackage{emptypage}
\RequirePackage{mparhack}
\RequirePackage{caption}
	\captionsetup{labelsep=period,font=small}
\RequirePackage{epigraph}                       
	\setlength{\beforeepigraphskip}{-3\baselineskip} 
	\setlength{\afterepigraphskip}{2\baselineskip}   
	\setlength{\epigraphrule}{0pt}                
	\renewcommand{\textflush}{flushepinormal}        
	\renewcommand{\sourceflush}{flushepinormal}      
	\renewcommand{\epigraphsize}{\footnotesize}  
\RequirePackage{enumitem}
\ifsuftesi@elements
	\setdescription{font=\normalfont\itshape,noitemsep}
	\setenumerate[1]{font=\normalfont,leftmargin=0pt,label=\arabic*}
	\setitemize[1]{font=\normalfont,leftmargin=0pt}
\else
	\setlist{labelsep=0.6em,itemsep=0ex,font=\normalfont}
	\setdescription{font=\normalfont\sffamily,itemsep=0ex}
	\setenumerate[1]{leftmargin=0pt,label=\arabic*}
	\setenumerate[2]{leftmargin= 1.3em,label=\arabic*}
	\setenumerate[3]{leftmargin= 1.3em,label=\arabic*}
	\setitemize[1]{leftmargin=0pt}
	\setitemize[2]{leftmargin=1.3em}
	\setitemize[3]{leftmargin=1.3em}
\fi	
%****************************************
% 		GREEK FONT
%****************************************
%...thanks to the TeX guru Enrico Gregorio
\ifxetex
   \relax
      \else
\RequirePackage[LGR,T1]{fontenc}
\AtBeginDocument{\fontencoding{T1}\selectfont}
\ifsuftesi@defaultfont
  \relax
    \else
\RequirePackage[osf,sc]{mathpazo}
\RequirePackage[scaled=0.8]{beramono}
   \linespread{1.05}
    \renewcommand{\sfdefault}{iwona}
  \fi
\ifsuftesi@artemisia
	\def\suftesi@greekfamily{artemisiaeuler}
    \fi
\ifsuftesi@defaultgreek
	\def\suftesi@greekfamily{cmr}
    \fi
\ifsuftesi@porson
	\sbox\z@{\fontsize{10}{10}\normalfont A} 
	\sbox\tw@{\font\temp=gporsonrg6a at 10pt \temp A} 
	\dimen@= 
	\dimexpr(0.001\dimexpr\numexpr(\dimexpr(1000\ht\z@)/\ht\tw@)\p@) 
	\edef\art@scale{\strip@pt\dimen@} 
	\DeclareFontFamily{LGR}{porson}{} 
	\DeclareFontShape{LGR}{porson}{m}{n}{<-> s * [\art@scale] gporsonrg6a}{} 
	\DeclareFontShape{LGR}{porson}{m}{it}{<-> ssub * porson/m/n}{} 
	\DeclareFontShape{LGR}{porson}{b}{n}{<-> ssub * porson/m/n}{} 
	\DeclareFontShape{LGR}{porson}{b}{it}{<-> ssub * porson/m/n}{} 
	\DeclareFontShape{LGR}{porson}{m}{sl}{<-> ssub * porson/m/n}{} 
	\DeclareFontShape{LGR}{porson}{b}{sl}{<-> ssub * porson/m/n}{} 
	\DeclareFontShape{LGR}{porson}{m}{sc}{<-> ssub * porson/m/n}{} 
	\DeclareFontShape{LGR}{porson}{bx}{n}{<-> ssub * porson/m/n}{} 
	\DeclareFontShape{LGR}{porson}{bx}{it}{<-> ssub * porson/m/n}{} 
	\DeclareFontShape{LGR}{porson}{bx}{sl}{<-> ssub * porson/m/n}{} 
      \def\suftesi@greekfamily{porson}
   \fi
\AtBeginDocument{
  \DeclareRobustCommand{\greektext}{%
    \fontencoding{LGR}\fontfamily{\suftesi@greekfamily}\selectfont
    \def\encodingdefault{LGR}}}
\fi
%****************************************
%		LAYOUT
%****************************************
\RequirePackage{geometry}
  \parindent1em
\ifcase\@ptsize\relax
	\geometry{%
	  textwidth=312pt,
	  textheight=624pt}\or
	\geometry{%
	  textwidth=324pt,
	  textheight=648pt}\or
	\geometry{%
	  textwidth=324pt,
	  textheight=648pt}
	  \fi
	\geometry{%
	  marginparsep=12pt,
	  includehead,
	  hmarginratio=1:2,
	  vmarginratio=1:2,
	  heightrounded,
	  marginparwidth=82pt,
	  }	  
\ifsuftesi@nocrop
     \relax
       \else
          \RequirePackage[a4,cam,center]{crop}
\fi
\ifsuftesi@compact
    \geometry{
    textheight=16.5cm,
    textwidth=11cm,
    paperwidth=16cm,
    paperheight=24cm,
    hmarginratio=2:3,
    vmarginratio=2:3,
    includefoot,
    includehead,
    heightrounded,
    marginparwidth=65pt,
    marginparsep=10pt,
    }
   \else
\ifsuftesi@supercompact
    \geometry{
    textheight=15cm,
    textwidth=10cm,
    paperwidth=14cm,
    paperheight=21cm,
    hmarginratio=2:3,
    vmarginratio=2:3,
    includefoot,
    includehead,
    heightrounded,
    marginparwidth=50pt,
    marginparsep=9pt,
}
   \else
\ifsuftesi@elements
\geometry{%
	textwidth=251pt,
	textheight=502pt,
	marginparwidth=60pt,
	marginparsep=18pt,
	paperwidth=378pt,
	paperheight=654pt,
    heightrounded,
	outer=90pt,
	top=64pt,
}

\else
	   \fi
    \fi 
 \fi
 \if@twoside
   \relax
     \else
   \geometry{hmarginratio=1:1}
\fi
%****************************************
%		SECTION TITLES
%****************************************
\RequirePackage{titlesec}
\DeclareRobustCommand{\suftesi@smallcaps}[1]{%
   \ifxetex
     \addfontfeature{LetterSpace=6}\MakeTextLowercase{\textsc{#1}}
       \else
         \textls{\MakeTextLowercase{\textsc{#1}}}
       \fi
       }%
\DeclareRobustCommand{\sufchaptersize}{%
	\ifsuftesi@supercompact\large\else\ifsuftesi@compact\Large\else\LARGE\fi\fi}
\ifsuftesi@article% article mode
	\renewcommand \thesection {\@arabic\c@section}
	\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection} 
	\renewcommand\thesubsubsection{\thesubsection.\@arabic\c@subsubsection}
	\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
	\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
\renewcommand\part{%
   \if@noskipsec \leavevmode \fi
   \par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}
\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >\m@ne
       \normalsize \partname\nobreakspace\thepart
       \par\nobreak
     \fi
     \large  #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 3ex
    \@afterheading}
\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}
\else% book mode
\titleformat{\part}[display]
	  {\LARGE\filcenter}
	  {\sufchaptersize\ifsuftesi@sctitles\scshape\else\fi\partname~\Roman{part}}
	  {3ex}
	  {\sufchaptersize\ifsuftesi@sctitles\expandafter\suftesi@smallcaps\else\fi}
\fi
% common settings
\ifsuftesi@centertitle
	\titleformat{\chapter}[display]
		  {\filcenter}
		  {\sufchaptersize\thechapter}
		  {3ex}
		  {\sufchaptersize\ifsuftesi@sctitles\expandafter\suftesi@smallcaps\else\fi}
    \else
	\titleformat{\chapter}[hang]
		  {\filright}
		  {\sufchaptersize\thechapter.}
		  {3ex}
		  {\sufchaptersize\ifsuftesi@sctitles\expandafter\suftesi@smallcaps\else\fi}
\fi
\ifsuftesi@compact
  \titlespacing*{\chapter}{0em}{0ex}{18ex}
    \else
      \ifsuftesi@supercompact 
        \titlespacing*{\chapter}{0em}{0ex}{18ex}
         \else
      \titlespacing*{\chapter}{0em}{6ex}{18ex}
   \fi
\fi
% Elements
\newcommand{\chapnumfont}[1]{%
	\ifxetex
	  \def\@chapnumfont{#1}
     \else
       \def\@chapnumfont{\fontfamily{#1}}
	  \fi}
\newcommand{\xechapnumfont}{\chapnumfont}

\xechapnumfont{Palatino}
\chapnumfont{pplj}
\DeclareRobustCommand{\sectitle}[1]{\textls{\MakeUppercase{#1}}}%

\ifsuftesi@sufelements
   \titleformat{\chapter}[block]
		  {\vskip-22pt}%
		  {\begin{picture}(0,0)
	\setlength{\unitlength}{1pt}
	\ifxetex
	  \fontspec{\@chapnumfont}%
	\else
	  \@chapnumfont
	  \fi
		  \ifsuftesi@elements
		    \fontsize{65}{65}\selectfont
		  \else
		    \fontsize{95}{95}\selectfont
		  \fi
		    \put(0,-88){%
		    \hskip\textwidth
		    \hskip\marginparsep
		   \textcolor{sufgray}{\thechapter}}%
		    \end{picture}}
		  {0pt}
		  {\sectitle}
		  [\rule{\textwidth}{.4pt}]
  	\titlespacing*{\chapter}{0em}{10pt}{10pt}[0em] 
\else\fi
\ifsuftesi@elements
\titleformat{\section}[hang]
	  {\raggedright}
	  {\textnormal\thesection}
	  {1em}
	  {\small\suftesi@smallcaps}
	\titlespacing*{\section}{0em}{10pt}{10pt}[0em] 
\titleformat{\subsection}[block]
	  {\filright\normalsize\itshape}
	  {\textnormal\thesubsection}
	  {1em}
	  {}
	\titlespacing*{\subsection}{0em}{10pt}{10pt}[0em] 
\titleformat{\subsubsection}[block]
	  {\filright\normalsize\itshape}
	  {\textnormal\thesubsubsection}
	  {1em}
	  {}
	\titlespacing*{\subsubsection}{0em}{10pt}{10pt}[0em] 
\else
\titleformat{\section}[hang]
	  {\filright}
	  {\thesection}
	  {.5em}
	  {\unskip\ifsuftesi@sctitles\expandafter\suftesi@smallcaps\else\itshape\fi}
	\titlespacing*{\section}{0ex}{\baselineskip}{\baselineskip}[0ex]	  
\fi
\titleformat{\subsection}[hang]
	  {}
	  {\textnormal\thesubsection}
	  {.5em}
	  {\itshape}
	\titlespacing*{\subsection}{\parindent}{\baselineskip}{\baselineskip}[0ex]
\titleformat{\subsubsection}[hang]
	  {}
	  {\textnormal\thesubsubsection}
	  {.5em}
	  {}
	\titlespacing*{\subsubsection}{\parindent}{\baselineskip}{\baselineskip}[0ex]  
\titleformat{\paragraph}[runin]
	  {\itshape}
	  {}
	  {}
	  {}
	  [\hspace*{1em}]
	\titlespacing*{\paragraph}{\parindent}{.5\baselineskip}{.5\baselineskip}
\titleformat{\subparagraph}[runin]
	  {}
	  {}
	  {}
	  {}
	  [.\hspace*{1em}]
	\titlespacing*{\subparagraph}{\parindent}{.5\baselineskip}{.5\baselineskip}
%****************************************
%		TOC, LOF, LOT
%****************************************
\RequirePackage{titletoc}
\ifsuftesi@article 
\renewcommand\tableofcontents{% article mode
	\thispagestyle{empty}
	    \section*{\contentsname
	        \@mkboth{\contentsname}{\contentsname}}%
	    \@starttoc{toc}%
	      \vspace*{2ex}
	    }
\else
\renewcommand\tableofcontents{% book mode
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\contentsname
        \@mkboth{\contentsname}{\contentsname}}%
    \@starttoc{toc}%
    \if@restonecol\twocolumn\fi
    }
 \fi
\titlecontents{part}                                                  
	[0em]                                                                    
	{\addvspace{3ex}\partname~}                                                 
	{\thecontentslabel\hspace*{1em}}                                                    
	{}                                                                      
	{}
	[\addvspace{1ex}]
\titlecontents{chapter}                                                  
	[0em]                                                                    
	{\addvspace{2ex}}                                                 
	{\thecontentslabel\hspace*{1em}}                                                    
	{}                                                                       
	{\titlerule*{}\contentspage}
	[\addvspace{1ex}]
  \titlecontents{section}
	[1.5em]
	{} 
	{\thecontentslabel\hspace*{1em}}
	{} 
	{\titlerule*{}\contentspage}
\titlecontents{subsection}
	[3em]
	{} 
	{\thecontentslabel\hspace*{1em}}
	{} 
	{\titlerule*{}\contentspage}
\titlecontents{subsubsection}
	[4.5em]
	{} 
	{\thecontentslabel\hspace*{1em}}
	{} 
	{\titlerule*{}\contentspage}	
\titlecontents{figure}
	[1.5em]
	{} 
	{\thecontentslabel\hspace*{1em}}
	{} 
	{\titlerule*{}\contentspage}
\titlecontents{table}
	[1.5em]
	{} 
	{\thecontentslabel\hspace*{1em}}
	{} 
	{\titlerule*{}\contentspage}
%****************************************
%		APPENDIX
%****************************************
\newcommand{\appendicesname}[1]{\def\suff@appendices{#1}}
\appendicesname{Appendici}
\newcommand{\appendixpage}{\@appendixpage}
\def\@appendixpage{%
\@mainmattertrue
\titlecontents{part}                                                  
	[0em]                                                                    
	{\addvspace{3ex}}                                                 
	{}                                                    
	{}                                                                      
	{}
	[\addvspace{1ex}]
\let\contentspage\relax
    \cleardoublepage
       \thispagestyle{empty}
         \addcontentsline{toc}{part}{\suff@appendices}
	  \begingroup
	    \centering
	       \null\vfil
		  {\LARGE\suff@appendices\par}
	       \vfil
	\endgroup
    \cleardoublepage
\titlecontents{part}                                                  
	[0em]                                                                    
	{\addvspace{3ex}\partname~}                                                 
	{\thecontentslabel\hspace*{1em}}                                                    
	{}                                                                      
	{}
	[\addvspace{1ex}]
}
\ifsuftesi@sufelements
\renewcommand\appendix{\par
	  \setcounter{chapter}{0}%
	  \setcounter{section}{0}%
	  \gdef\@chapapp{\appendixname}%
	  \gdef\thechapter{\@Alph\c@chapter}
	  \titleformat{\chapter}[block]
		  {\vskip-22pt}%
		  {\small\sectitle{\appendixname}~\Alph{chapter}:\hskip.5em}
		  {0pt}
		  {\small\sectitle}
		  [\rule{\textwidth}{.4pt}]
	\titlespacing*{\chapter}{0em}{10pt}{10pt}[0em]
	\titlecontents{chapter}[1em]                                                                  
	  {\filright\hskip.5em}                                   
	  {\suftesi@smallcaps{\appendixname~\thecontentslabel:}\hskip1em}                                                                   
	  {}                                                       
	  {\contentspage\vspace{5pt}}}
	  \else
\renewcommand\appendix{\par
	  \setcounter{chapter}{0}%
	  \setcounter{section}{0}%
	  \gdef\@chapapp{\appendixname}%
	  \gdef\thechapter{\@Alph\c@chapter}}
\fi
%****************************************
% 		HEADINGS
%****************************************
\RequirePackage{fancyhdr}
\pagestyle{fancy}
\renewcommand{\headrulewidth}{0pt} 
\renewcommand{\footnoterule}{}
\ifsuftesi@elements	% Elements
	\renewcommand{\chaptermark}[1]{\markboth{#1}{#1}}
	\renewcommand{\sectionmark}[1]{\markright{#1}}
\else							% book
	\renewcommand{\chaptermark}[1]{\markboth{\chaptertitlename\ \thechapter}{#1}}
	\renewcommand{\sectionmark}[1]{}
\fi
\ifsuftesi@article		% article
    	  \renewcommand{\sectionmark}[1]{\markright{\thesection.\ #1}}
  \else\fi
\ifsuftesi@sctitles
  \ifsuftesi@authortitle
    \def\suf@rightmark{\suftesi@smallcaps{\@title}}
  \else
    \def\suf@rightmark{\suftesi@smallcaps{\rightmark}}
  \fi
\else
  \ifsuftesi@authortitle
    \def\suf@rightmark{\nouppercase{\@title}}
  \else
    \def\suf@rightmark{\nouppercase{\rightmark}}
  \fi
\fi
\ifsuftesi@sctitles
  \ifsuftesi@authortitle
    \def\suf@leftmark{\suftesi@smallcaps{\@author}}
  \else
    \def\suf@leftmark{\suftesi@smallcaps{\suf@leftrightmark}}
  \fi
\else
  \ifsuftesi@authortitle
    \def\suf@leftmark{\nouppercase{\@author}}
  \else
    \def\suf@leftmark{\nouppercase{\suf@leftrightmark}}
  \fi
\fi
\ifsuftesi@sctitles
  \def\sufthepage{\suftesi@smallcaps{\thepage}}
\else
  \def\sufthepage{\thepage}
\fi
\def\suf@leftrightmark{%
	\if@mainmatter\leftmark\else\rightmark\fi} 
\fancypagestyle{plain}{%
	\fancyhf{}
	\fancyfoot[C]{}
	\renewcommand{\headrulewidth}{0pt}
	\renewcommand{\footrulewidth}{0pt}}	
\fancypagestyle{sufplain}{%
	\fancyhf{}%
	\fancyfoot[RE,LO]{\ifsuftesi@bozza \footnotesize Version of \today\else\fi}
	\fancyfoot[C]{\footnotesize\sufthepage}}
\fancypagestyle{centerheadings}{%
		\fancyhf{}%
		\fancyfoot[RE,LO]{\ifsuftesi@bozza \footnotesize Version of \today\else\fi}
		\fancyhead[CO]{\footnotesize\xheadbreakfalse\suf@rightmark} 
		\fancyhead[CE]{\footnotesize\xheadbreakfalse%
			\ifsuftesi@article
			  \ifsuftesi@authortitle
			    \suf@leftmark
			      \else
			        \suf@rightmark
			      \fi
			  \else
			    \suf@leftmark
			  \fi} 
		\fancyfoot[C]{\footnotesize\sufthepage}%
		}
\fancypagestyle{sufdefault}{%
		\fancyhf{}%
		\fancyfoot[RE,LO]{\ifsuftesi@bozza \footnotesize Version of \today\else\fi}
		\fancyhead[LE,RO]{\footnotesize\sufthepage} 
		\fancyhead[LO]{\footnotesize\xheadbreakfalse\suf@rightmark}
		\fancyhead[RE]{\footnotesize\xheadbreakfalse%
			\ifsuftesi@article
			  \ifsuftesi@authortitle
			    \suf@leftmark
			      \else
			        \suf@rightmark
			       \fi
			  \else
			    \suf@leftmark
			  \fi}
		}
\fancypagestyle{elements}{%
	\fancyhf{}
	\fancyfoot[LE,RO]{\thepage} 
	\fancyhead[RO]{%
		\begin{picture}(0,0)
		   \setlength{\unitlength}{1pt}
		      \put(0,-104){%
		\hskip\marginparsep
		\parbox[t]{\marginparwidth}{\itshape\raggedright\leftmark}}%
		\end{picture}} 
	\fancyhead[LE]{%
		\begin{picture}(0,0)
		   \setlength{\unitlength}{1pt}
		      \put(0,-104){%
		\hskip-\marginparwidth
		\hskip-\marginparsep
		      \parbox[t]{\marginparwidth}{\itshape\raggedleft\rightmark}}%
		\end{picture}}	
		}		
%\renewcommand{\author}[1]{\gdef\@sufauthor{#1}}
%\def\@sufauthor{--missing author--% 
%  \ClassWarningNoLine{suftesi} 
%    {Missing \protect\author}% 
%    \gdef\univrart@author{--missing author--}}
%
%\renewcommand{\title}[1]{\gdef\@suftitle{#1}}
%\def\@suftitle{--missing title--% 
%  \ClassWarningNoLine{suftesi} 
%    {Missing \protect\title}% 
%    \gdef\univrart@author{--missing title--}}
\pagestyle{sufdefault}
\ifsuftesi@centerheadings\pagestyle{centerheadings}\else\fi
\ifsuftesi@sufplain\pagestyle{sufplain}\else\fi
\ifsuftesi@elements\pagestyle{elements}\else\fi

%****************************************
%	TITLE PAGE 
%****************************************
\let\standardtitle\maketitle
\if@titlepage% titlepage
  \renewcommand\maketitle{\begin{titlepage}%
  \let\footnotesize\small
  \let\footnoterule\relax
  \let \footnote \thanks
  \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
  \null\vfil
  \vskip 60\p@
  \begin{center}%
    {\sufchaptersize\color{sufred}\sffamily\ifsuftesi@sctitles\suftesi@smallcaps{\@title}\else\@title\fi \par}%
    \vskip 3em%
    {\small\lineskip .75em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
      \vskip 1.5em%
    {\small\@date\par}%       
  \end{center}\par
  \@thanks
  \vfil\null
  \end{titlepage}%
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
%  \global\let\@author\@empty
     \global\let\@date\@empty
%  \global\let\@title\@empty
%  \global\let\title\relax
%  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
\else% notitlepage
\renewcommand\maketitle{\par
	  \begingroup
	    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
	    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
	    \long\def\@makefntext##1{\parindent 1em\noindent
	            \hb@xt@1.8em{%
	                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
	    \if@twocolumn
	      \ifnum \col@number=\@ne
	        \@maketitle
	      \else
	        \twocolumn[\@maketitle]%
	      \fi
	    \else
	      \newpage
	      \global\@topnum\z@   % Prevents figures from going at top of page.
	      \@maketitle
	    \fi
	    \thispagestyle{plain}\@thanks
	  \endgroup
	  \setcounter{footnote}{0}%
	  \global\let\thanks\relax
	  \global\let\maketitle\relax
	  \global\let\@maketitle\relax
	  \global\let\@thanks\@empty
%	  \global\let\@author\@empty
	  \global\let\@date\@empty
%	  \global\let\@title\@empty
%	  \global\let\title\relax
%	  \global\let\author\relax
	  \global\let\date\relax
	  \global\let\and\relax}
     \def\@maketitle{%
	  \newpage
	  \null
	  \vskip 2em%
	  \begin{center}%
	  \let \footnote \thanks
	    {\sufchaptersize\color{sufred}\sffamily\ifsuftesi@sctitles\suftesi@smallcaps{\@title}\else\@title\fi\par}%
	    \vskip 1.5em%
	    {\small\lineskip .5em%
	      \begin{tabular}[t]{c}%
        \@author\par
	      \end{tabular}\par}%
	    \vskip 1em%
	    {\small\@date\par}%
	  \end{center}%
	  \par
	  \vskip 1.5em}
\fi
%****************************************
%		NOTES
%****************************************
\RequirePackage{ltxcmds}
\renewcommand\@makefntext{\hskip-2.5em\makebox[2em][r]{\@thefnmark}\hskip.5em}
% thanks to Lorenzo Pantieri and Enrico Gregorio
\def\graffito@setup{%
   \itshape\footnotesize%
   \parindent=0pt \lineskip=0pt \lineskiplimit=0pt %
   \tolerance=2000 \hyphenpenalty=300 \exhyphenpenalty=300%
   \doublehyphendemerits=100000%
   \finalhyphendemerits=\doublehyphendemerits}
\newcommand{\graffito}[1]{\marginnote%
 [\graffito@setup\raggedleft\hspace{0pt}{#1}]%
 {\graffito@setup\raggedright\hspace{0pt}{#1}}}
 \let\marginnote\marginpar
 \def\marginpar{% thanks to Antonio Macrì
   \@ifnextchar[\marginnote\graffito}
\ifsuftesi@nomarginpar
	\let\graffito\@gobble
	\renewcommand\marginpar[2][]{}
	  \else
	\fi
%***************************************
%		COLOPHON
%****************************************
\edef\compilatore{% 
  \ifxetex 
  \noexpand\XeLaTeX 
  \else 
      \ifluatex 
        Lua\noexpand\LaTeX 
      \else 
       \noexpand\LaTeX 
      \fi 
  \fi}
\newcommand{\colophon}[3][]{%
	\thispagestyle{empty}
	\null
	  \vfill
	   \def\next{#2}
	       \ifx\next\@empty\else
	          \noindent Copyright \copyright{} \the\year~#2\\[1ex]
	        Tutti i diritti sono riservati.
	      \fi
	\vfill	
    \section*{Colophon}
	{\small Questo lavoro \`e stato realizzato con \compilatore{}%
	   \def\next{#1}
	      \ifx\next\@empty\else su #1 
	    \fi usando la classe \textsf{suftesi} di 
	    Ivan Valbusa\index{Valbusa, Ivan}. #3\par}
	    \cleardoublepage}
\newcommand{\bookcolophon}[2]{%
	\thispagestyle{empty}
	\null
	  \vfill
	          \noindent #1
	\vfill	
    \section*{Colophon}
	{\small #2\par}
	    \cleardoublepage}
\newcommand{\artcolophon}[1]{%
\thispagestyle{empty}
	\null
	  \vfill
	{\small #1\par}}
%****************************************
%		INDEX
%****************************************
\renewenvironment{theindex}
	{\renewcommand{\indexname}{Indice dei nomi}
	    \setlength\columnseprule{0pt}
	      \setlength\columnsep{35pt}%
	        \cleardoublepage
		  \@makeschapterhead{\indexname}%
	\begin{multicols}{2}
	     \markboth{\indexname}{\indexname}%
	        \raggedright\small
	         \setlength\parindent{0pt}%
	         \setlength\parskip{0pt plus 0.3pt}%
	      \thispagestyle{plain}\let\item\@idxitem}
	{\end{multicols}}
\renewcommand\@idxitem{\par\hangindent 15\p@}
%****************************************
%	BIBLIOGRAPHY AND SHORTHANDS
%****************************************
\newenvironment{bibliografia}{%
  \ifsuftesi@article
    \section*{\refname}
     \addcontentsline{toc}{section}{\refname}
  \else
	\chapter{\bibname}%
  \fi
  		\normalfont \list{}{%
			\setlength{\itemindent}{-\parindent}
			\setlength{\leftmargin}{\parindent}
			\setlength{\labelwidth}{\leftmargin}
			\setlength{\parsep}{\parskip}
			\let\makelabel}}
	{\endlist}
\newcommand{\losname}{Sigle}
\newcommand{\itlabel}[1]{\itshape\hbox to 6em{#1}}
\newenvironment{sigle}{%
	\chapter{\losname}
		\normalfont \list{}{%
			\setlength{\labelsep}{0.5em}
			\setlength{\itemindent}{0pt}
			\setlength{\leftmargin}{6em}
			\setlength{\labelwidth}{\leftmargin}
			\setlength{\listparindent}{\parindent}
			\setlength{\parsep}{\parskip}
			\let\makelabel\itlabel}}
	{\endlist}
%*************************************************************
% 		ENVIRONMENTS
%*************************************************************
% quotations
\renewcommand\labelitemii{\normalfont \textendash}
\renewenvironment{quotation}
               {\list{}{\listparindent\parindent%
                        \itemindent    \listparindent
                        \rightmargin   \parindent
                        \leftmargin     \parindent
                        \parsep        \z@ \@plus\p@}%
               \item\relax\footnotesize\noindent\ignorespaces}
               {\endlist}
\renewenvironment{quote}
               {\list{}{\rightmargin \parindent
                         \leftmargin    \parindent}%
                \item\relax\footnotesize}
               {\endlist}
\renewenvironment{verse}
               {\let\\\@centercr
                \list{}{\footnotesize%
                		\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}	
% abstract
\if@titlepage
  \newenvironment{abstract}{%
      \titlepage
      \null\vfil
      \@beginparpenalty\@lowpenalty
      \begin{center}%
         \abstractname
        \@endparpenalty\@M
      \end{center}}%
     {\par\vfil\null\endtitlepage}
\else
  \newenvironment{abstract}{%
      \if@twocolumn
        \section*{\abstractname}%
      \else
        \small
        \begin{center}%
          {\abstractname\vspace{-.5em}\vspace{\z@}}%
        \end{center}%
        \quotation
      \fi}
      {\if@twocolumn\else\endquotation\fi}
\fi
%*************************************************************
% 		 COMMANDS
%*************************************************************
\def\chapterintro{
  \@ifstar{\@tempswafalse\@chapterintro}{\@tempswatrue\@chapterintro}}
\def\@chapterintro{\phantomsection
  \if@tempswa\section*{\suffchapterintroname}\fi
  \addcontentsline{toc}{section}{\suffchapterintroname}}
\newcommand{\chapterintroname}[1]{\def\suffchapterintroname{#1}}
\chapterintroname{Introduzione}
\newcommand{\hemph}[1]{\penalty10000\hskip0pt\emph{#1}}
%	breaks in toc but not in headings and text 
\newif\ifheadbreak\headbreakfalse  
	\DeclareRobustCommand{\headbreak}  
		{\ifheadbreak\\\else\fi}
%	breaks in text and headings but not in toc
\newif\ifxheadbreak\xheadbreaktrue
	\DeclareRobustCommand{\xheadbreak} 
		{\ifxheadbreak\\\else\fi}
\let\origtableofcontents\tableofcontents
	\renewcommand{\tableofcontents}{%
		\begingroup\headbreaktrue\xheadbreakfalse%
	\origtableofcontents\endgroup}
%****************************************
% 		PAGE NUMBERS
%****************************************
\renewcommand\frontmatter{\cleardoublepage\@mainmatterfalse} 
\renewcommand\mainmatter{\cleardoublepage\@mainmattertrue} 

\frenchspacing
\hfuzz=1.5pt 

\endinput


